#define _CRT_SECURE_NO_WARNINGS
#include <bits/stdc++.h>

using namespace std;

class kompleksniBroj
{
private:
    long long int re;
    long long int im;
public:
    void setRe(long long int Re) { re = Re; }
    long long int getRe() const { return re; }
    void setIm(long long int Im) { im = Im; }
    long long int getIm() const { return im; }

    kompleksniBroj(long long int Re, long long int Im)
    {
        re = Re;
        im = Im;
    }

    kompleksniBroj() : kompleksniBroj(0, 0) {}

    long double moduo() const
    {
        return hypot(im, re);
    }

    string to_string()
    {
        return std::to_string(re) + "+j" + std::to_string(im);
    }

    static kompleksniBroj zbir(const vector<kompleksniBroj>& brojevi, int duzina)
    {
        long long int reSum = 0, imSum = 0;
        for (int i = 0; i < duzina; i++)
        {
            reSum += brojevi[i].getRe();
            imSum += brojevi[i].getIm();
        }

        kompleksniBroj izlaz(reSum, imSum);

        return izlaz;

    }
};

void provera(const vector<kompleksniBroj>& vektori, kompleksniBroj& tekuci, const kompleksniBroj zbir, const vector<int> indeksi, vector<vector<int>>& provereni, vector<int>& tekuciIndeksi)
{
    if (indeksi.size() == 1)
        if (vektori[indeksi[0]].moduo() > tekuci.moduo())
        {
            tekuci = vektori[indeksi[0]];
            return;
        }

    if (find(provereni.begin(), provereni.end(), indeksi) != provereni.end()) return;

    vector<kompleksniBroj> trenutni(indeksi.size());
    for (int i = 0; i < indeksi.size(); i++)
        trenutni[i] = vektori[indeksi[i]];

    kompleksniBroj ispit;

    for (int i = 0; i < indeksi.size(); i++)
    {
        vector <int> noviIndeksi;
        for (int j = 0; j < indeksi.size(); j++) if (j != i) noviIndeksi.push_back(indeksi[j]);
        ispit.setRe(zbir.getRe() - trenutni[i].getRe());
        ispit.setIm(zbir.getIm() - trenutni[i].getIm());
        if (ispit.moduo() > tekuci.moduo())
        {
            tekuci = ispit;
            tekuciIndeksi = noviIndeksi;
        }
        provera(vektori, tekuci, ispit, noviIndeksi, provereni, tekuciIndeksi);

        provereni.push_back(noviIndeksi);
    }
}

int main()
{
    int n;
    scanf("%d", &n);

    vector <kompleksniBroj> vektori(n);
    vector <vector<int>> provereni;
    vector <int> dobriIndeksi;

    for (int i = 0; i < n; i++)
    {
        int pom1, pom2;
        scanf("%d%d", &pom1, &pom2);
        vektori[i].setRe(pom1);
        vektori[i].setIm(pom2);
    }

    kompleksniBroj tekuci = kompleksniBroj::zbir(vektori, n);
    vector<int> indeksi(n);
    for (int i = 0; i < n; i++) indeksi[i] = i;
    provera(vektori, tekuci, tekuci, indeksi, provereni, dobriIndeksi);

    for (int i = 0; i < dobriIndeksi.size(); i++)
    {
        printf("%d ", dobriIndeksi[i]+1);
    }

    return 0;
}